function [fverts,rot_idx] = flat_verts(verts,nanout)
%This function takes in a set of x y z vertices, and flattens all of the
%vertices along the z axis, thus rotation both x,y to the proper positions.
%Synatax:   [fverts,rot_idx] = flat_verts(verts);
%Input:     verts = an n by 3 array, with each column being x y z.
%           nanout = remove nan, default = 1, yes
%Output:    fverts = the flattened vertices [x y 0]
%           rot_idx = The x,y rotation indexes.

if nargin<2
    nanout = 1;     %default
end

% %find the clockwise rotations
% neg_idx = ones(size(verts,1),1);           %start the index
% neg_idx(verts(:,3)>0&verts(:,2)>0) = -1;        %clockwise rotation is -degree angle of rotation
% neg_idx(verts(:,3)<0&verts(:,2)<0) = -1;
% 
% %Now calculate the angle of rotation on the x axis
% %calculate vector 1, ori - termi  rotated
% v1 = horzcat(zeros(size(verts,1),1),hypot(verts(:,3),verts(:,2)));   %rotating along x axis to y 0, everything will be aligned to the z axis
% v_idx = ones(size(verts,1),1);      %hypot makes everything positive, in this case there are negative x values, not like syn_align
% v_idx(verts(:,2)<0) = -1;
% v1(:,2) = v1(:,2).*v_idx;       %back to negative!
% v2 = verts(:,[3 2]);      %the origial y z plane 
% for m = 1:size(verts,1)    %calculate the dot product for each pair of vectors
%     x_rot(m,1) = dot(v2(m,:),v1(m,:));     %calculate the dot product, which gives us the cos of the angle
% end
% %x_rot = acos(x_rot./(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2)))).*180/pi;        %calculate the angles in degress.
% x_rot = acosd(single(x_rot)./single(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2))));        %calculate the angles in degress.
% %modify rotation angles
% x_rot = x_rot.*neg_idx;         %clockwise and counter clockwise set.
% %rotate the base vector
% vert_tmp = verts;
% for m = 1:size(x_rot,1)
%     rotx_tmp = [cosd(x_rot(m,1)),-sind(x_rot(m,1));sind(x_rot(m,1)),cosd(x_rot(m,1))]*verts(m,[2 3])';    %rotation in x plane
%     vert_tmp(m,2:3) = [rotx_tmp(1) rotx_tmp(2)];
% end

%find the clockwise rotations
% neg_idx = ones(size(verts,1),1);           %start the index
% neg_idx(vert_tmp(:,3)>0&verts(:,1)>0) = -1;        %clockwise rotation is -degree angle of rotation
% neg_idx(vert_tmp(:,3)<0&verts(:,1)<0) = -1;
% neg_idx(verts(:,3)<0) = -1;

% %calculte the angle of roation on the z axis
% v3 = horzcat(zeros(size(verts,1),1),hypot(verts(:,3),verts(:,1)));   %rotating along the y axis axis to z = 0
% v_idx = ones(size(verts,1),1);      %hypot makes everything positive, in this case there are negative x values, not like syn_align
% v_idx(verts(:,1)<0) = -1;
% v3(:,2) = v3(:,2).*v_idx;       %back to negative!
% v4 = verts(:,[3 1]);      %the origial vector
% for n = 1:size(verts,1)        %Dot product per pair of vectors
%     y_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
% end
% %y_rot = acos(y_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
% y_rot = acosd(single(y_rot)./single(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2))));        %calculate the angles in degress.
% %modify rotation angles
% y_rot = y_rot.*neg_idx;         %clockwise and counter clockwise set.

%calculate the angle of roation on the z axis
%nverts = new_xy(verts);     %get the new vertices for the rotated vector
% v3 = [nverts(:,1) nverts(:,2) zeros(size(verts,1),1)];   %rotating along the y axis axis to z = 0
% v4 = verts;      %the origial vector
% for n = 1:size(verts,1)        %Dot product per pair of vectors
%     y_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
% end
% %y_rot = acos(y_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
% y_rot = acosd(single(y_rot)./single(hypot(hypot(v3(:,1),v3(:,2)),v3(:,3)).*hypot(hypot(v4(:,1),v4(:,2)),v4(:,3))));        %calculate the angles in degress.
% %modify rotation angles
% y_rot = y_rot.*neg_idx;         %clockwise and counter clockwise set.
% x_rot = y_rot;
% 
% %now rotate the third points
% for l = 1:size(verts,1)     %go through the vertices
%     %roty_tmp = [cosd(y_rot(l,1)),sind(y_rot(l,1));-sind(y_rot(l,1)),cosd(y_rot(l,1))]*verts(l,[1 3])';    %rotate in the z plane
%     roty_tmp = [1 0 0;0,cosd(x_rot(l,1)),-sind(x_rot(l,1));0,sind(x_rot(l,1)),cosd(x_rot(l,1))]*...
%         [cosd(y_rot(l,1)),0,sind(y_rot(l,1));0 1 0;-sind(y_rot(l,1)),0,cosd(y_rot(l,1))]*verts(l,:)';
%     %fverts(l,:) = [roty_tmp(1) rotx_tmp'];        %store new rotate vertex.
%     %vert_tmp(l,[1 3]) = [roty_tmp(1) roty_tmp(2)];        %store new rotated vertex.
%     vert_tmp(l,:) = roty_tmp';        %store new rotated vertex.
% end
% fverts = vert_tmp;
% fverts(isnan(fverts)) = 0;      %Nan is 0
% %rot_idx = [x_rot y_rot];
% rot_idx = [y_rot];
vert_tmp = new_xy(verts);       %new xy
fverts = [vert_tmp(:,1) vert_tmp(:,2) zeros(size(verts,1),1)];      %really this simple, flattened
%fverts = unique(fverts,'rows');     %clean the dataset
%if there are properties attached to the verts, add them on here
if size(verts,2)>3
    fverts = horzcat(fverts,verts(:,4:end));
end
if nanout
    fverts(isnan(fverts(:,2)),:) = [];   %NaN values are junk
end
rot_idx = [];
%--------------------------------------------------------------------------
%subfunction to calculate the vector components of the new rotated line
function [xy] = new_xy(verts)

c = hypot(hypot(verts(:,1),verts(:,2)),verts(:,3));     %the magnitude the vector 
xy = sqrt((c.*c)./((verts(:,2)./verts(:,1).*verts(:,2)./verts(:,1))+1));      %new x value (the two .* is for squaring!  really!
neg_idx = ones(size(verts,1),1);           %make sure x stays the same sign
neg_idx(verts(:,1)<0) = -1;
xy = xy.*neg_idx;       %ok back to right.
xy(isnan(xy)) = 0;      %Also Nan is 0
xy(:,2) = (verts(:,2)./verts(:,1)).*xy(:,1);        %new y value